REM **** FT980B ****
REM **** Control Yaesu FT980 Tranceiver with PC Compatibles ****
REM **** In Quick Basic ****
REM **** By W. Van Horn - K3CP Nov. 21, 1989 ****
REM **** 1454 KELCHNER RD. BETHLEHEM, PA. 18018  USA
REM on error goto Error.Trap
true% = 0
menu1:
CLS
COLOR 2
PRINT "      Program to control a Yaesu FT-980 with a PC compatible computer."
PRINT
PRINT "Ext Toggle   <ET>     Select Freq     <SF>    Set Mode     <SM>"
PRINT "Ham VFO      <HV>     General VFO     <GV>    FSK Shift    <FS>"
PRINT "Rx Clarifier <RC>     Tx Clarifier    <TC>    LDB          <LD>"
PRINT "IF Width     <IW>     IF Shift        <IS>    Memory Ch    <MC>"
PRINT "Fine Tuning  <FT>     SW Menu         <SW>    VFO Status   <VF>"
PRINT "Spec Toggle  <SP>     End             <QQ>"
PRINT : PRINT "Please make Selection from menu. "
COLOR 3
	Choice$ = INPUT$(2)
	IF Choice$ = "HV" OR Choice$ = "hv" THEN GOSUB HamVFO
	IF Choice$ = "SM" OR Choice$ = "sm" THEN GOSUB SetMode
	IF Choice$ = "FS" OR Choice$ = "fs" THEN GOSUB FskShift
	IF Choice$ = "LD" OR Choice$ = "ld" THEN GOSUB SetLDB
	IF Choice$ = "FT" OR Choice$ = "ft" THEN GOSUB FineTuning
	IF Choice$ = "RC" OR Choice$ = "rc" THEN GOSUB RXClar
	IF Choice$ = "QQ" OR Choice$ = "qq" THEN GOSUB Terminate
	IF Choice$ = "IW" OR Choice$ = "iw" THEN GOSUB IFWidth
	IF Choice$ = "GV" OR Choice$ = "gv" THEN GOSUB GenVFO
	IF Choice$ = "IS" OR Choice$ = "is" THEN GOSUB IFShift
	IF Choice$ = "TC" OR Choice$ = "tc" THEN GOSUB TXClar
	IF Choice$ = "SF" OR Choice$ = "sf" THEN GOSUB SetFreq
	IF Choice$ = "ET" OR Choice$ = "et" THEN GOSUB ExtCont
	IF Choice$ = "SW" OR Choice$ = "sw" THEN GOSUB SWLMenu
	IF Choice$ = "MC" OR Choice$ = "mc" THEN GOSUB MemCh
	IF Choice$ = "VF" OR Choice$ = "vf" THEN GOSUB VFO
	IF Choice$ = "SP" OR Choice$ = "sp" THEN GOSUB SP
GOTO menu1
SP:
CLOSE #1: OPEN "COM1:4800,N,8,2,DS0" FOR OUTPUT AS #1
begin:
INPUT "Enter 0, 1 or -1 "; X$

	IF X$ = "-1" THEN END
SELECT CASE X$
	CASE "0"
		FIVE.BYTE% = &H0
		GOSUB Send.Command
	CASE "1"
		FIVE.BYTE% = &HB
		GOSUB Send.Command
	END SELECT
GOTO begin
Send.Command:
	FOR J% = 1 TO 4
	GOSUB TD
	PRINT #1, CHR$(0);
	  NEXT J%
	  GOSUB TD
PRINT #1, CHR$(FIVE.BYTE%);
RETURN
TD:
	FOR k = 1 TO 1: NEXT k
	RETURN
SetFreq:
 REM **** Convert decimal to hex and set frequency ***
LOCATE 17, 8
INPUT "Enter frequency in Khz."; FREQ$
'CLS

freq2:
IF LEN(FREQ$) = 5 THEN FREQ$ = "0" + FREQ$ + "00"
IF LEN(FREQ$) = 4 THEN FREQ$ = "00" + FREQ$ + "00"
IF LEN(FREQ$) = 3 THEN FREQ$ = "000" + FREQ$ + "00"
F1$ = MID$(FREQ$, 1, 2)
F2$ = MID$(FREQ$, 3, 2)
F3$ = MID$(FREQ$, 5, 2)
F4$ = MID$(FREQ$, 7, 2)
F1$ = "&H" + F1$
F2$ = "&H" + F2$
F3$ = "&H" + F3$
F4$ = "&H" + F4$
FREQ.BYTE1 = VAL(F1$): FREQ.BYTE2 = VAL(F2$)
FREQ.BYTE3 = VAL(F3$): FREQ.BYTE4 = VAL(F4$)
FIVE.BYTE% = &H8
GOSUB Fivebyte.Instruction
GOSUB OK.Signal
RETURN
FineTuning:
DO
CLS
LOCATE 5, 16
COLOR 6: PRINT "Select the increment you want. (Q) to END"
COLOR 3
LOCATE 7, 20: PRINT "Up"; : COLOR 4: PRINT SPACE$(34); "Down"
LOCATE 9, 2: COLOR 3
PRINT " <1>   <2>    <3>    <4>     <5>";
COLOR 4: PRINT "    <6>    <7>     <8>    <9>    <0>"
LOCATE 11, 2: COLOR 3
PRINT "Band  5 Khz  1 Khz  100 Hz  10 Hz";
COLOR 4: PRINT "  10 Hz  100 Hz  1 Khz  5 Khz  Band"
COLOR 3
404 X$ = INKEY$: IF X$ = "" THEN 404
 SELECT CASE X$
	 CASE "1"
	  GOSUB Band.Up
	 CASE "2"
	  GOSUB Khz.Up.5
	 CASE "3"
	  FOR i% = 1 TO 10
	  GOSUB Hz.Up.100
	  NEXT i%
	 CASE "4"
	  GOSUB Hz.Up.100
	 CASE "5"
	  GOSUB Hz.Up.10
	 CASE "6"
	  GOSUB Hz.Down.10
	 CASE "7"
	  GOSUB Hz.Down.100
	 CASE "8"
	  FOR i% = 1 TO 10
	  GOSUB Hz.Down.100
	  NEXT i%
	 CASE "9"
	  GOSUB Khz.Down.5
	 CASE "0"
	  GOSUB Band.Down
	 CASE "Q"
	 CASE "q"
	  RETURN
	 CASE ELSE
END SELECT
LOOP
SWLMenu:

CLS
	GOSUB GenVFO
	FOUR.BYTE% = &H14
	FIVE.BYTE% = &HA
	GOSUB Twobyte.Instruction
	GOSUB OK.Signal
	GOSUB get.time
table.00:
DO
LOCATE 14, 1
PRINT "Make selection"
COLOR 6
m1$ = "\            \  \             \  \             \  \             \"
PRINT USING m1$; "25-WWV"; "26-WWV"; "27-CHU"; "28-CHU"
PRINT
PRINT "QQ-Return to Main Menu."
Choice$ = INPUT$(2)

SELECT CASE Choice$
	CASE "25"
	  FREQ$ = "2500"
	  qth$ = "WWV"
	CASE "26"
	  FREQ$ = "5000"
	  qth$ = "WWV"
	CASE "27"
	  FREQ$ = "3335"
	  qth$ = "CHU"
	CASE "28"
	  FREQ$ = "7335"
	  qth$ = "CHU"
	CASE "QQ"
	  GOTO menu1
	CASE ELSE
END SELECT
freqx = VAL(FREQ$)
COLOR 11: LOCATE 2, 22: PRINT USING "\          \"; " Station is "; qth$;
PRINT USING "##.###"; (freqx / 1000); : PRINT " Mhz."
COLOR 10
qth$ = ""
GOSUB freq2
LOOP
table.01:
DO
LOCATE 14, 1
PRINT "Make selection"
COLOR 6
m1$ = "\            \  \             \  \             \  \             \"
PRINT USING m1$; "10-Prague"; "11-W.Germany"; "12-Moscow"
PRINT USING m1$; "25-WWV"; "26-WWV"; "27-CHU"; "28-CHU"
PRINT
PRINT "QQ-Return to Main Menu."
Choice$ = INPUT$(2)
SELECT CASE Choice$
	CASE "10"
	 FREQ$ = "7345"
	 qth$ = "Prague"
	CASE "11"
	 FREQ$ = "6145"
	 qth$ = "W.Germany"
	CASE "12"
	 FREQ$ = "9720"
	 qth$ = "Moscow"
	CASE "25"
	  FREQ$ = "2500"
	  qth$ = "WWV"
	CASE "26"
	  FREQ$ = "5000"
	  qth$ = "WWV"
	CASE "27"
	  FREQ$ = "3335"
	  qth$ = "CHU"
	CASE "28"
	  FREQ$ = "7335"
	  qth$ = "CHU"
	CASE "QQ"
	CASE "qq"
	   GOTO menu1
	COLOR 3
	   GOTO menu1
	CASE ELSE
END SELECT
freqx = VAL(FREQ$)
COLOR 11: LOCATE 2, 22: PRINT USING "\          \"; " Station is "; qth$;
PRINT USING "##.###"; (freqx / 1000); : PRINT " Mhz."
COLOR 10
qth$ = ""
GOSUB freq2
LOOP
table.02:
DO
LOCATE 14, 1
PRINT "Make selection"
COLOR 6
m1$ = "\            \  \             \  \             \  \             \"
PRINT USING m1$; "10-S. Africa"; "11-Canada"; "12-E.Germany"; "13-Bucharest"
PRINT USING m1$; "14-Netherlands"; "15-Switzerland"; "16-VOFC"
PRINT USING m1$; "25-WWV"; "26-WWV"; "27-CHU"; "28-CHU"
PRINT
PRINT "QQ-Return to Main Menu."
Choice$ = INPUT$(2)
SELECT CASE Choice$
	CASE "10"
	 FREQ$ = "9615"
	 qth$ = "S. Africa"
	CASE "11"
	 FREQ$ = "9535"
	 qth$ = "Canada"
	CASE "12"
	 FREQ$ = "6080"
	 qth$ = "E. Germany"
	CASE "13"
	 FREQ$ = "5990"
	 qth$ = "Bucharest"
	CASE "14"
	 FREQ$ = "6020"
	 qth$ = "Netherlands"
	CASE "15"
	 FREQ$ = "6135"
	 qth$ = "Switzerland"
	CASE "16"
	FREQ$ = "5985"
	qth$ = "VOFC"
	CASE "25"
	  FREQ$ = "2500"
	  qth$ = "WWV"
	CASE "26"
	  FREQ$ = "5000"
	  qth$ = "WWV"
	CASE "27"
	  FREQ$ = "3335"
	  qth$ = "CHU"
	CASE "28"
	  FREQ$ = "7335"
	  qth$ = "CHU"
	CASE "QQ"
	CASE "qq"
	   GOTO menu1
	COLOR 3
	   GOTO menu1
	CASE ELSE
END SELECT
freqx = VAL(FREQ$)
COLOR 11: LOCATE 2, 22: PRINT USING "\          \"; " Station is "; qth$;
PRINT USING "##.###"; (freqx / 1000); : PRINT " Mhz."
COLOR 10
qth$ = ""
GOSUB freq2
LOOP
table.20:
DO
LOCATE 14, 1
PRINT "Make selection"
COLOR 6
m1$ = "\            \  \             \  \             \  \             \"
PRINT
PRINT USING m1$; "10-WWV"; "11-WWV"; "12-CHU"; "13-CHU"
PRINT USING m1$; "16-WABC"; "17-WKAP"
PRINT USING m1$; "22-Cairo"
PRINT "QQ-Return to Main Menu."
Choice$ = INPUT$(2)
SELECT CASE Choice$
	CASE "10"
	  FREQ$ = "15000"
	  qth$ = "WWV"
	CASE "11"
	  FREQ$ = "20000"
	  qth$ = "WWV"
	CASE "12"
	  FREQ$ = "7335"
	  qth$ = "CHU"
	CASE "13"
	  FREQ$ = "10335"
	  qth$ = "CHU"
	CASE "16"
	  FREQ$ = "770"
	  qth$ = "WABC"
	CASE "17"
	  FREQ$ = "1320"
	  qth$ = "WKAP"
	CASE "QQ"
	CASE "22"
	  FREQ$ = "15375"
	  qth$ = "Cairo"
	CASE "qq"
	   GOTO menu1
	COLOR 3
	   GOTO menu1
	CASE ELSE
END SELECT
freqx = VAL(FREQ$)
COLOR 11: LOCATE 2, 22: PRINT USING "\          \"; " Station is "; qth$;
PRINT USING "##.###"; (freqx / 1000); : PRINT " Mhz."
COLOR 10
qth$ = ""
GOSUB freq2
LOOP
table.23:
DO
LOCATE 14, 1
PRINT "Make selection"
COLOR 6
m1$ = "\            \  \             \  \             \  \             \"
PRINT USING m1$; "10-London"; "11-Moscow"; "12-South Africa"; "13-Canada"
PRINT USING m1$; "14-Portugal"; "15-Praque"; "16-Switerland"; "17-China (VOFC)"
PRINT USING m1$; "18-Germany"; "19-Greece"; "20-Japan"; "21-Vatican"
PRINT USING m1$; "22"; "23"; "24"
PRINT USING m1$; "25-WWV"; "26-WWV"; "27-CHU"; "28-CHU"
PRINT
PRINT "QQ-Return to Main Menu."
Choice$ = INPUT$(2)
SELECT CASE Choice$
	CASE "10"
	 FREQ$ = "9590"
	 qth$ = "London"
	CASE "11"
	  FREQ$ = "9720"
	  qth$ = "Moscow"
	CASE "12"
	 FREQ$ = "9615"
	 qth$ = "South Africa"
	CASE "13"
	 FREQ$ = "9755"
	 qth$ = "Canada"
	CASE "14"
	 FREQ$ = "9705"
	 qth$ = "Portugal"
	CASE "15"
	 FREQ$ = "7345"
	 qth$ = "Prague"
	CASE "16"
	 FREQ$ = "9885"
	 qth$ = "Switzerland"
	CASE "17"
	 FREQ$ = "5985"
	 qth$ = "Taiwan-VOFC"
	CASE "18"
	 FREQ$ = "6100"
	 qth$ = "W.Germany"
	CASE "19"
	 FREQ$ = "9420"
	 qth$ = "Greece"
	CASE "20"
	 FREQ$ = "5960"
	 qth$ = "Japan"
	CASE "21"
	 FREQ$ = "11780"
	 qth$ = "Vatican"
	CASE "25"
	  FREQ$ = "10000"
	  qth$ = "WWV"
	CASE "26"
	  FREQ$ = "15000"
	  qth$ = "WWV"
	CASE "27"
	  FREQ$ = "3335"
	  qth$ = "CHU"
	CASE "28"
	  FREQ$ = "7335"
	  qth$ = "CHU"
	CASE "QQ"
	CASE "qq"
	   GOTO menu1
	COLOR 3
	   GOTO menu1
	CASE ELSE
END SELECT
freqx = VAL(FREQ$)
COLOR 11: LOCATE 2, 22: PRINT USING "\          \"; " Station is "; qth$;
PRINT USING "##.###"; (freqx / 1000); : PRINT " Mhz."
COLOR 10
qth$ = ""
GOSUB freq2
LOOP

get.time:
   PRINT "Select time - UTC - First 2 numbers."
   INPUT "What time - UTC"; utc$
   CLS
   IF utc$ = "00" THEN GOSUB table.00
   IF utc$ = "01" THEN GOSUB table.01
   IF utc$ = "02" THEN GOSUB table.02
   IF utc$ = "20" THEN GOSUB table.20
   IF utc$ = "23" THEN GOSUB table.23
   PRINT "Time not available."
	RETURN
MemCh:
	 FOUR.BYTE% = &H1E
	 FIVE.BYTE% = &HA
	 GOSUB Twobyte.Instruction
	 GOSUB OK.Signal
DO UNTIL Num$ = "00"
CLS
PRINT "Enter number - 01 to 12 --- 00 to End"
PRINT
Num$ = INPUT$(2)
SELECT CASE Num$
	CASE "00"
	   GOTO menu1
	CASE "01"
		 FOUR.BYTE% = &H0
	  CASE "02"
		 FOUR.BYTE% = &H1
	  CASE "03"
		 FOUR.BYTE% = &H2
	  CASE "04"
		 FOUR.BYTE% = &H3
	CASE "05"
		 FOUR.BYTE% = &H4
	  CASE "06"
		 FOUR.BYTE% = &H5
	  CASE "07"
		 FOUR.BYTE% = &H6
	  CASE "08"
		 FOUR.BYTE% = &H7
	CASE "09"
		 FOUR.BYTE% = &H8
	  CASE "10"
		 FOUR.BYTE% = &H9
	  CASE "11"
		 FOUR.BYTE% = &H10
	  CASE "12"
		 FOUR.BYTE% = &H11
	CASE ELSE
END SELECT
		FIVE.BYTE% = &HA
		GOSUB Twobyte.Instruction
		GOSUB OK.Signal
LOOP
RETURN
VFO:
CLS
PRINT "Make Selection."
PRINT
PRINT "QQ - End"
PRINT "RM - Rcve  Controlled by Memory"
PRINT "RV - Rcve  Controlled by VFO"
PRINT "MR - Memory"
PRINT "VF - VFO"
DO
VFO$ = INPUT$(2)
SELECT CASE VFO$
	CASE "RM"
	CASE "rm"
	 FOUR.BYTE% = &H1C
	CASE "RV"
	CASE "rv"
	 FOUR.BYTE% = &H1D
	CASE "MR"
	CASE "mr"
	 FOUR.BYTE% = &H1E
	CASE "VF"
	CASE "vf"
	 FOUR.BYTE% = &H1F
	CASE "QQ"
	CASE "qq"
	 GOTO menu1
	CASE ELSE
 END SELECT
	FIVE.BYTE% = &HA
	GOSUB Twobyte.Instruction
	GOSUB OK.Signal
LOOP
RETURN
SetMode:
REM **** Set Mode ****
1410 CLS
1420 PRINT "LSB    USB    CWW    CWN    AMW    AMN    FSK    FM"
1430 PRINT " 1      2      3      4      5      6      7      8"
1440 Choice$ = INPUT$(1)
1450 IF Choice$ = "1" THEN MODE% = &H10
1460 IF Choice$ = "2" THEN MODE% = &H11
1470 IF Choice$ = "3" THEN MODE% = &H12
1480 IF Choice$ = "4" THEN MODE% = &H13
1490 IF Choice$ = "5" THEN MODE% = &H14
1500 IF Choice$ = "6" THEN MODE% = &H15
1510 IF Choice$ = "7" THEN MODE% = &H16
1520 IF Choice$ = "8" THEN MODE% = &H17
1530 FOUR.BYTE% = MODE%
1540 FIVE.BYTE% = &HA
1550 GOSUB Twobyte.Instruction
1560 GOSUB OK.Signal
1570 RETURN
IFWidth:
 REM **** IF Width ****
1610 CLS
PRINT "IF Width"
PRINT "Make Choice----0 to exit routine"
PRINT "<--Wide.......................Center.....................Narrow-->"
PRINT "     1      2      3      4      5      6      7      8      9"
Choice$ = INPUT$(1)
IF Choice$ = "1" THEN FOUR.BYTE% = 0
IF Choice$ = "2" THEN FOUR.BYTE% = 32
IF Choice$ = "3" THEN FOUR.BYTE% = 64
IF Choice$ = "4" THEN FOUR.BYTE% = 96
IF Choice$ = "5" THEN FOUR.BYTE% = 128
IF Choice$ = "6" THEN FOUR.BYTE% = 154
IF Choice$ = "7" THEN FOUR.BYTE% = 186
IF Choice$ = "8" THEN FOUR.BYTE% = 218
IF Choice$ = "9" THEN FOUR.BYTE% = 255
IF Choice$ = "0" THEN RETURN
FIVE.BYTE% = &H4
GOSUB Twobyte.Instruction
GOSUB OK.Signal
GOTO IFWidth
IFShift:
 REM **** IF Shift ****
1810 CLS
1815 PRINT "IF Shift"
PRINT "Make Choice----0 to exit routine"
PRINT "<--Left.......................Center.....................Right-->"
PRINT "     1      2      3      4      5      6      7      8      9"
Choice$ = INPUT$(1)
IF Choice$ = "1" THEN FOUR.BYTE% = 0
IF Choice$ = "2" THEN FOUR.BYTE% = 4
IF Choice$ = "3" THEN FOUR.BYTE% = 8
IF Choice$ = "4" THEN FOUR.BYTE% = 12
IF Choice$ = "5" THEN FOUR.BYTE% = 16
IF Choice$ = "6" THEN FOUR.BYTE% = 20
IF Choice$ = "7" THEN FOUR.BYTE% = 24
IF Choice$ = "8" THEN FOUR.BYTE% = 28
IF Choice$ = "9" THEN FOUR.BYTE% = 32
IF Choice$ = "0" THEN RETURN
FIVE.BYTE% = &H5
GOSUB Twobyte.Instruction
GOSUB OK.Signal
GOTO IFShift
FskShift:
 REM *** FSK Shift ***
CLS
PRINT "  Switch    170 hz    425 hz   850 hz"
PRINT "    1         2         3        4"
FSK$ = INPUT$(1)
IF FSK$ = "1" THEN FSK% = &H0
IF FSK$ = "2" THEN FSK% = &HC0
IF FSK$ = "3" THEN FSK% = &H40
IF FSK$ = "4" THEN FSK% = &H80
FOUR.BYTE% = FSK%
FIVE.BYTE% = &H6
GOSUB Twobyte.Instruction
GOSUB OK.Signal
RETURN
GenVFO:
REM Set General VFO
GOSUB Clear.Bytes
FOUR.BYTE% = &H21
FIVE.BYTE% = &HA
GOSUB Twobyte.Instruction
GOSUB OK.Signal
RETURN
HamVFO:
REM **** Han VFO ****
GOSUB Clear.Bytes
FOUR.BYTE% = &H22
FIVE.BYTE% = &HA
GOSUB Twobyte.Instruction
GOSUB OK.Signal
RETURN
SetLDB:
REM *** SET LDB ***
GOSUB Clear.Bytes
FIVE.BYTE% = &H9
GOSUB Onebyte.Instruction
GOSUB OK.Signal
RETURN
TXClar:
 REM **** TX Clarifier ****
GOSUB Clear.Bytes
FOUR.BYTE% = &H26
FIVE.BYTE% = &HA
GOSUB Twobyte.Instruction
GOSUB OK.Signal
RETURN
RXClar:
 REM **** RX Clarifier ****
GOSUB Clear.Bytes
FOUR.BYTE% = &H27
FIVE.BYTE% = &HA
GOSUB Twobyte.Instruction
GOSUB OK.Signal
RETURN
Khz.Up.5:
 REM **** 5 Khz Up ****
GOSUB Clear.Bytes
FOUR.BYTE% = &H2C: FIVE.BYTE% = &HA
GOSUB Twobyte.Instruction
GOSUB OK.Signal
RETURN
Khz.Down.5:
 REM **** 5 Khz Down ****
GOSUB Clear.Bytes
FOUR.BYTE% = &H2B: FIVE.BYTE% = &HA
GOSUB Twobyte.Instruction
GOSUB OK.Signal
RETURN
Band.Up:
 REM *** BAND UP ***
GOSUB Clear.Bytes
FOUR.BYTE% = &H2F
FIVE.BYTE% = &HA
GOSUB Twobyte.Instruction
GOSUB OK.Signal
RETURN
Band.Down:
REM *** BAND DOWN ***
GOSUB Clear.Bytes
FOUR.BYTE% = &H2D: FIVE.BYTE% = &HA
GOSUB Twobyte.Instruction
GOSUB OK.Signal
RETURN
Hz.Up.10:
GOSUB Clear.Bytes
FIVE.BYTE% = &H2
GOSUB Onebyte.Instruction
GOSUB OK.Signal
RETURN
Hz.Down.10:
GOSUB Clear.Bytes
FIVE.BYTE% = &H3
GOSUB Onebyte.Instruction
GOSUB OK.Signal
RETURN
Hz.Up.100:
REM **** 100 Hz Up ****
GOSUB Clear.Bytes
FOUR.BYTE% = &H18: FIVE.BYTE% = &HA
GOSUB Twobyte.Instruction
GOSUB OK.Signal
RETURN
Hz.Down.100:
 REM **** 100 Hz Down ****
GOSUB Clear.Bytes
FOUR.BYTE% = &H20: FIVE.BYTE% = &HA
GOSUB Twobyte.Instruction
GOSUB OK.Signal
RETURN
Khz.Up.1:
 REM **** 1 Khz Up ****
FOR J% = 1 TO 10
GOSUB Clear.Bytes
FOUR.BYTE% = &H18: FIVE.BYTE% = &HA
GOSUB Twobyte.Instruction
GOSUB OK.Signal
NEXT J%
RETURN
Khz.Down.1:
 REM **** 1 Khz Down ****
FOR J% = 1 TO 10
GOSUB Clear.Bytes
FOUR.BYTE% = &H20: FIVE.BYTE% = &HA
GOSUB Twobyte.Instruction
GOSUB OK.Signal
NEXT J%
RETURN
Error.Trap:
REM **** Error handling routine ****
IF ERR <> 52 THEN RESUME menu1
CLS
LOCATE 12, 20
PRINT "File not open. Execute External Control."
PRINT TAB(20); "Hit any key to resume."
A$ = INPUT$(1)
Clear.Bytes:
 REM **** Clear Bytes ****
FOR Q% = 1 TO 5: GOSUB Time.Delay: FREQ.BYTE%(Q%) = 0: NEXT Q%
RETURN
Onebyte.Instruction:
FOR Q% = 1 TO 4: GOSUB Time.Delay: PRINT #1, CHR$(DUMMY.BYTE%(Q%)); : NEXT Q%
GOSUB Time.Delay
PRINT #1, CHR$(FIVE.BYTE%);
RETURN
Twobyte.Instruction:
FOR Q% = 1 TO 3: GOSUB Time.Delay: PRINT #1, CHR$(DUMMY.BYTE%(Q%)); : NEXT Q%
GOSUB Time.Delay
PRINT #1, CHR$(FOUR.BYTE%); : GOSUB Time.Delay: PRINT #1, CHR$(FIVE.BYTE%);
RETURN
Fivebyte.Instruction:
PRINT #1, CHR$(FREQ.BYTE4);
GOSUB Time.Delay
PRINT #1, CHR$(FREQ.BYTE3);
GOSUB Time.Delay
PRINT #1, CHR$(FREQ.BYTE2);
GOSUB Time.Delay
PRINT #1, CHR$(FREQ.BYTE1);
GOSUB Time.Delay
PRINT #1, CHR$(FIVE.BYTE%);
REM gosub Time.Delay
RETURN
ExtCont:
GOSUB Open.Com.File
FIVE.BYTE% = &H0
GOSUB Onebyte.Instruction
GOSUB OK.Signal
GOSUB SetLDB
RETURN
OK.Signal:
GOSUB Clear.Bytes
FIVE.BYTE% = &HB
GOSUB Onebyte.Instruction
RETURN
Open.Com.File:
	true% = 1
CLOSE #1: OPEN "COM1:4800,N,8,2,DS0" FOR OUTPUT AS #1
RETURN
Time.Delay:
	FOR i = 1 TO 1: NEXT i: RETURN
Terminate:
	IF true% = 0 THEN GOTO menu1
	GOSUB ExtCont
PRINT "Program terminated by the Operator."
CLOSE #1:
END

